<?php
/**
 * This file is used to generate the "Import" page in the admin.
 *
 * @package live-news
 */

if ( ! current_user_can( get_option( $this->shared->get( 'slug' ) . '_import_menu_capability' ) ) ) {
	wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'daln' ) );
}

?>

<!-- output -->

<div class="wrap">

	<h2><?php esc_html_e( 'Live News - Import', 'daln' ); ?></h2>

	<div id="daext-menu-wrapper">

		<?php

		// Process the xml file upload.
		if ( isset( $_FILES['file_to_upload'] ) &&
			isset( $_FILES['file_to_upload']['name'] ) &&
			preg_match( '/^.+\.xml$/', $_FILES['file_to_upload']['name'], $matches ) === 1
		) {

			// Nonce verification.
			check_admin_referer( 'daln_import_data', 'daln_import_data_nonce' );

			if ( file_exists( $_FILES['file_to_upload']['tmp_name'] ) ) {

				// Delete the records of all the database tables of the plugin.
				$this->shared->reset_plugin_database_tables();

				global $wpdb;

				$counter_ticker        = 0;
				$counter_featured_news = 0;
				$counter_sliding_news  = 0;
				$ticker_id_hash_table  = array();

				// Read xml file.
				$xml = simplexml_load_file( $_FILES['file_to_upload']['tmp_name'] );

				// Import Tickers -------------------------------------------------------------------------------------.
				$ticker_a = $xml->tickers;

				$num = count( $ticker_a );

				for ( $i = 0; $i < $num; $i++ ) {

					// Convert object to array.
					$single_ticker_a = get_object_vars( $ticker_a[ $i ] );

					// Replace objects with empty strings to prevent notices on the next insert() method.
					$single_ticker_a = $this->shared->replace_objects_with_empty_strings( $single_ticker_a );

					/*
					 * Save the ticker_id key for later use and remove the ticker_id key from the
					 * main array.
					 */
					$current_ticker_id = $single_ticker_a['id'];
					unset( $single_ticker_a['id'] );

					$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_tickers';
					$wpdb->insert(
						$table_name,
						$single_ticker_a
					);
					$inserted_ticker_id = $wpdb->insert_id;
					$counter_ticker    += $wpdb->rows_affected;

					// Add the old and new ticker_id in the hash table.
					$ticker_id_hash_table[ $current_ticker_id ] = $inserted_ticker_id;

				}

				// Import Featured News -------------------------------------------------------------------------------.
				$featured_news_a = $xml->featured_news;

				$num = count( $featured_news_a );

				for ( $i = 0; $i < $num; $i++ ) {

					// Convert object to array.
					$single_featured_news_a = get_object_vars( $featured_news_a[ $i ] );

					// Replace objects with empty strings to prevent notices on the next insert() method.
					$single_featured_news_a = $this->shared->replace_objects_with_empty_strings( $single_featured_news_a );

					// Remove the id key.
					unset( $single_featured_news_a['id'] );

					// Replace the ticker_id value with zero or the one available in $ticker_id_hash_table.
					if ( intval( $single_featured_news_a['ticker_id'], 10 ) === 0 ) {
						$single_featured_news_a['ticker_id'] = 0;
					} else {
						$single_featured_news_a['ticker_id'] = $ticker_id_hash_table[ $single_featured_news_a['ticker_id'] ];
					}

					$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_featured_news';
					$wpdb->insert(
						$table_name,
						$single_featured_news_a
					);
					$inserted_featured_news_id = $wpdb->insert_id;
					$counter_featured_news    += $wpdb->rows_affected;

				}

				// Import Sliding News --------------------------------------------------------------------------------.
				$sliding_news_a = $xml->sliding_news;

				$num = count( $sliding_news_a );

				for ( $i = 0; $i < $num; $i++ ) {

					// Convert object to array.
					$single_sliding_news_a = get_object_vars( $sliding_news_a[ $i ] );

					// Replace objects with empty strings to prevent notices on the next insert() method.
					$single_sliding_news_a = $this->shared->replace_objects_with_empty_strings( $single_sliding_news_a );

					// Remove the id key.
					unset( $single_sliding_news_a['id'] );

					// Replace the ticker_id value with zero or the one available in $ticker_id_hash_table.
					if ( intval( $single_sliding_news_a['ticker_id'], 10 ) === 0 ) {
						$single_sliding_news_a['ticker_id'] = 0;
					} else {
						$single_sliding_news_a['ticker_id'] = $ticker_id_hash_table[ $single_sliding_news_a['ticker_id'] ];
					}

					$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_sliding_news';
					$wpdb->insert(
						$table_name,
						$single_sliding_news_a
					);
					$inserted_sliding_news_id = $wpdb->insert_id;
					$counter_sliding_news    += $wpdb->rows_affected;

				}

				$success_message  = '<div class="updated settings-error notice is-dismissible below-h2">';
				$success_message .= '<p>' . esc_html__( 'The following elements have been added:', 'daln' ) . ' ';
				$success_message .= $counter_ticker . ' ' . esc_html__( 'tickers', 'daln' ) . ', ';
				$success_message .= $counter_featured_news . ' ' . esc_html__( 'featured news', 'daln' ) . ', ';
				$success_message .= $counter_sliding_news . ' ' . esc_html__(
					'sliding news',
					'daln'
				) . '</p></div>';

				echo $success_message;

			}
		}

		?>

		<p>
		<?php
		esc_html_e(
			'Import the plugin data stored in your XML file by clicking the Upload file and import button.',
			'daln'
		);
		?>
				</p>
		<form enctype="multipart/form-data" id="import-upload-form" method="post" class="wp-upload-form" action="">
			<p>
				<label for="upload"><?php esc_html_e( 'Choose a file from your computer:', 'daln' ); ?></label>
				<input type="file" id="upload" name="file_to_upload">
				<?php wp_nonce_field( 'daln_import_data', 'daln_import_data_nonce' ); ?>
			</p>
			<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary"
									value="<?php esc_attr_e( 'Upload file and import', 'daln' ); ?>"></p>
		</form>
		<p>
			<strong>
			<?php
			esc_html_e(
				'IMPORTANT: This process deletes all the existing plugin data.',
				'daln'
			);
			?>
					</strong></p>

	</div>

</div>